<?php

namespace App\Task\Member;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Member extends Model 
{

    protected $table = 'member';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'full_name');
    protected $visible = array('full_name');

    public function getTask()
    {
        return $this->hasMany('Task');
    }

    public function getUser()
    {
        return $this->hasOne('User');
    }

}